<?PHP /* 108 Lines */

/* -------------------------------------------------------- */
/* ------- SYSTEM SETTINGS for v4.2 from 02.02.2023 ------- */
/* -------------------------------------------------------- */

    // SETTINGS - THIS IS THE NAME OF THE DATA-FILE IN THE /data/ FOLDER
    $TYPE = 'Tasks'; // ON CHANGES REMEMBER TO RENAME ALSO THE FILE IN THE /data/ FOLDER
    //      'Issues'     see https://en.wikipedia.org/wiki/Issue_tracking_system
    //      'Bugs'       see https://en.wikipedia.org/wiki/Bug_tracking_system
    //      'MOSCOW'     see https://en.wikipedia.org/wiki/MoSCoW_method
    //      'GTD'        see https://en.wikipedia.org/wiki/Getting_Things_Done
    //      'Aufgaben'   Tasks Management System in German (Deutsch)
    //      'Etapas'     Tasks Management System in Portuguese (Brazil)

    // SET THE DATE MODE - USE 'C' = 'Creation date!' OR 'D' = 'Deadline!'
    $MODE = 'D'; // DEFAULT 'D'

    // SHOW THE ADD FORM AT THE PAGE BOTTOM (true) - IF false SHOW FORM AT PAGE TOP
    $FORM = false; // DEFAULT false

    // ONLY THE ADMIN IS ALLOWED TO DELETE ENTRIES - TRUE = YES AND FALSE = NO
    $ADEL = true; // DEFAULT true

    // USE THE OWNER FEATURE - TRUE = YES AND FALSE = NO
    $UTOW = true; // DEFAULT true

    // ONLY THE ADMIN IS ALLOWED TO ADD THE ENTRIES OWNER - TRUE = YES AND FALSE = NO
    $AAOW = true; // DEFAULT true

    // ONLY THE ADMIN IS ALLOWED TO EDIT THE ENTRIES OWNER - TRUE = YES AND FALSE = NO
    $AEOW = true; // DEFAULT true

    // SHOW BACKUP-LINK IN MAIN NAVIGATION (ALWAYS FOR ADMIN ONLY) - TRUE = YES AND FALSE = NO
    $SBAK = false; // DEFAULT true

    //  SHOW Excel-EXPORT-LINK IN MAIN NAVIGATION (ALWAYS FOR ADMIN ONLY) - TRUE = YES AND FALSE = NO
    $SEXP = false; // DEFAULT true

    // USE FILE UPLOAD IN EDIT MOD (ALWAYS FOR ALL USER) - TRUE = YES AND FALSE = NO
    $UUPL = true; // DEFAULT true
    // define all allowed file types (NEVER ALLOW json)
    $UPLOAD_ALLOWED_FILE_TYPES = array(
      'jpg', 'png', 'jpg', 'jpeg', 'gif', 'bmp', /* IMAGES */
      'doc', 'rtf', 'txt', 'docx', 'pdf',        /* TEXT   */
      'mp3', 'mp4', 'wav', 'mpg',                /* MEDIA  */    
      'xls', 'csv', 'xlsx',                      /* TABLE  */
      'zip', 'rar',                              /* ARCHIV */
    );
    // define max. File Size in MB for one upload file
    $UPLOAD_MAX_FILE_SIZE_ADMIN = 5; // in MB

    //  Default Priority for a new task (must look the same as one option value from the used /setup/prio.txt file)
        $PRID = '1&nbsp;MEDIUM';                             /* DEFAULT '1&nbsp;MEDIUM' (use &nbsp; for the space) */
    //  Default Status for a new task (must look the same as one option value from the used /setup/$TYPE/prio.txt file)
        $STAD = 'TODO';                                      /* DEFAULT 'TODO' */
    //  Default Owner of a new task (must look the same as one users value from the $DATA array in this /setup/config.php file)
        $OWND = 'admin';                                     /* DEFAULT 'admin' (write the username completely in lowercase letters) */


//  LOGIN
    // MAKE USE OF LOGIN - TRUE = YES AND FALSE = NO
    $USEL = true; // DEFAULT true

    // ACCOUNTS (USERNAME => PASSWORD) - SHOULD BE CHANGED BEFORE FIRST REAL USE!
    // USER SEE ONLY THERE OWN RECORDS, ONLY THE USER NAMED 'admin' SEE ALL RECORDS!
    $DATA = array(
    /* User   =>  Password */
      'admin' => 'Temp159',
    );


//  FORMAT
    // SET TIMEZONE - SEE: https://www.php.net/manual/en/timezones.php
    date_default_timezone_set('UTC'); // DEFAULT 'UTC'

    // DATE FORMAT FOR DATA FILE - SEE: http://php.net/manual/en/function.date.php
    $DATE = 'm.d.Y'; // DEFAULT 'Y.m.d'
    #$DATE = 'd.m.Y'; // DEFAULT for germany
    $TIME = 'H:m'; // DEFAULT 'H:m'

    // DATE FORMAT FOR JS DATEPICKER - SEE: http://materializecss.com/pickers.html
    $PICK = 'mm.dd.yyyy'; // DEFAULT 'yyyy.mm.dd'
    #$PICK = 'dd.mm.yyyy'; // DEFAULT for germany

    // INITIAL TABLE SORT - SEE: https://mottie.github.io/tablesorter/docs/index.html#sortlist
    // EXAMPLE: '[1,0],[2,0]' = sort columns (2nd and 3rd) both Ascending
    // The second parameter is the sortDirection: 0 is for Ascending and 1 is for Descending
    $SORT = '[4,1],[1,0]'; // DEFAULT '[1,0]' // SORT BY 2nd COLUMN DATE, OLDEST DATE FIRST

    // DATE FORMAT FOR TABLE SORT
    $DSOR = 'mmddyyyy'; // DEFAULT 'yyyymmdd'
    #$DSOR = 'ddmmyyyy'; // DEFAULT for germany

    // NAME LENGHT IN CHARACTERS (Half the number of characters are displayed in the table)
    $NLEN = 128; // DEFAULT 128

    // TEXT LENGHT IN CHARACTERS (Half the number of characters are displayed in the table)
    $TLEN = 256; // DEFAULT 256

    // SET DEFAULT LANGUAGE (IF BROWSER-LANGUAGE DOSN'T EXIST) 'en' = english 'de' = german 'pt' = portuguese
    // AND don't forget to rename the /setup/xx_prio.txt you need to /setup/prio.txt
    $LANG = 'en'; // USE 'en', 'de' or 'pt' 

    // LOGIN SESSION HASH
    $SALT = 'emuFLwJbwg'; // USE first value from URL https://randomkeygen.com/

/* ----------------- */
/* EOF - END OF FILE */
/* ----------------- */
