<?php

/* SHOW (ALSO NEED UPDATE IN tpl/header.php AND tpl/footer.php) */

/**
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR 
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

// DISPLAY ALL ERRORS
ini_set('display_errors', 1);
error_reporting(E_ALL);

// REMOVE XSS ATTACKS WHILE STILL ALLOWING HTML (FIX 04.06.2019) - https://tinyurl.com/yye4h2dm
require_once 'lib/HTMLPurifier.standalone.php';
$HTMLPurifier_config = HTMLPurifier_Config::createDefault();
$HTMLPurifier = new HTMLPurifier($HTMLPurifier_config);
if (isset($_POST)) {
  foreach($_POST as $key => $dirty_input) {
    $_POST[$key] = $HTMLPurifier->purify($dirty_input);
  }
}
if (isset($_GET)) {
  foreach($_GET as $key => $dirty_input) {
    $_GET[$key] = $HTMLPurifier->purify($dirty_input);
  }
}

// START & CONFIG
ob_start();
require 'setup/config.php';

// SET LANGUAGE
if ( isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) AND
     file_exists('lang/'.substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2).'.php')
   ) {
   @include_once('lang/'.substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2).'.php');
} else {
  @include_once('lang/'.$LANG.'.php');
}

// INI VARs
$file = 'data/'.$TYPE.'.json'; // DATA FILE NAME

// READ DATA
$data = json_decode( str_replace("\u00a0", '&nbsp;', file_get_contents( $file ) ), true );

// REBUILD ARRAY TO ACCESS THE RECORD BY THE ID FIELD AND NOT BY THE LINE NUMBER
foreach ( $data as $no => $line ) {
  foreach ( $line as $key => $value ) {
    $dat[$line['id']]["$key"] = $value;
  }
}
#echo'<pre>';die(var_dump($dat));

// SHOW ENCODE / DECODE
if ( is_numeric($_GET['id']) and isset($_GET['DEV']) )  {
  $id = substr(md5($_GET['id']), 0, 7).rtrim(base64_encode($_GET['id']), '=');
} else {
  $_GET['id'] = base64_decode(substr($_GET['id'], 7));
  $id = '';
}
$USEL = false; // false = NO LOGOUT LINK
$SBAK = false; // false = NO BACKUP LINK
$SEXP = false; // false = NO EXPORT LINK
$NOSE = true;  //  true = NO SEARCH SLOT

// HEADER
ob_end_flush();
include 'tpl/header.php';

if ( isset($dat[@$_GET['id']]['id'])) {
?>
<div class="badge grey lighten-3 hoverable" style="padding:1em">
  <h3 class="grey-text text-darken-2"><?php echo $i18n['Info'].' '.$id; ?></h3>
  <div class="row">
    <div class="input-field col m2 s12">
      <label class="active" for="date"><?php echo $i18n['Date']; ?></label><br>
      <?php echo $dat[@$_GET['id']]['date']; ?>
    </div>
    <div class="input-field col m10 s12">
      <label class="active" for="name"><?php echo $i18n['Name']; ?></label><br>
      <?php echo $dat[@$_GET['id']]['name']; ?>
    </div>
    <div class="input-field col s12">
      <label class="active" for="text"><?php echo $i18n['Text']; ?></label><br>
      <?php echo $dat[@$_GET['id']]['text']; ?>
    </div>
    <div class="input-field col m4 s12">
      <label class="active" for="prio"><?php echo $i18n['Priority']; ?></label><br>
      <?php echo @$dat[@$_GET['id']]['prio'];?>
    </div>
    <div class="input-field col m4 s12">
      <label class="active" for="status"><?php echo $i18n['Label']; ?></label><br>
      <?php echo $dat[@$_GET['id']]['status'];?>
    </div>
    <div class="input-field col m4 s12">
      <label class="active" for="owner"><?php echo $i18n['Owner']; ?></label><br>
      <?php echo ucwords($dat[@$_GET['id']]['owner']); ?>
    </div>
  </div>
</div>
<br>

<?php
} else {
  echo '<h3 class="grey-text text-darken-2">' . $i18n["Sorry, there was an error."].'</h3>';
}

// FOOTER
include 'tpl/footer.php';
